// Kurs Popup Script
const API_URL = 'http://localhost:52525';

async function checkConnection() {
  const dot = document.getElementById('statusDot');
  const text = document.getElementById('statusText');

  try {
    const controller = new AbortController();
    const timeoutId = setTimeout(() => controller.abort(), 3000);

    const response = await fetch(`${API_URL}/api/status`, {
      signal: controller.signal
    });

    clearTimeout(timeoutId);

    if (response.ok) {
      const data = await response.json();
      if (data.status === 'ok') {
        dot.className = 'status-dot connected';
        text.textContent = 'Forbundet til Kurs';
      } else {
        throw new Error('Invalid status');
      }
    } else {
      throw new Error('Server error');
    }
  } catch (error) {
    dot.className = 'status-dot disconnected';
    text.textContent = 'Kurs kører ikke';
  }
}

// Check connection when popup opens
checkConnection();
