# JobTracker Chrome Extension

Chrome extension til at gemme LinkedIn jobs direkte til JobTracker appen.

## Installation

1. Åbn Chrome og gå til `chrome://extensions/`
2. Slå "Developer mode" til (øverst til højre)
3. Klik "Load unpacked"
4. Vælg `chrome-extension` mappen fra JobTracker projektet
5. Extension er nu installeret og vises i Chrome toolbar

## Brug

1. **Sørg for at JobTracker appen kører** - Extension kommunikerer med appen via localhost
2. Gå til et LinkedIn jobopslag (f.eks. `linkedin.com/jobs/view/...`)
3. Klik på "Gem til JobTracker" knappen der vises på siden
4. Jobbet gemmes som draft i JobTracker appen

## Status

Klik på extension ikonet i Chrome toolbar for at se forbindelsesstatus:
- **Grøn prik**: Forbundet til JobTracker
- **Rød prik**: JobTracker kører ikke - start appen først

## Understøttede URL'er

- `linkedin.com/jobs/view/[id]`
- `linkedin.com/jobs/collections/[type]/[id]`
- Andre LinkedIn job-sider

## Hvad gemmes

Når du klikker "Gem til JobTracker" scrapes følgende data:
- Jobtitel
- Virksomhedsnavn
- Virksomhedens LinkedIn URL (hvis tilgængelig)
- Fuld job beskrivelse
- Job URL

Jobbet oprettes som draft (`is_draft = true`) så du nemt kan finde og redigere det i appen.

## Fejlfinding

### "JobTracker kører ikke" fejl
- Start JobTracker desktop appen
- Vent et par sekunder
- Prøv igen

### Knappen vises ikke
- Genindlæs LinkedIn siden
- Tjek at du er på en job-side (URL indeholder `/jobs/`)
- Nogle LinkedIn layouts har forskellige strukturer - knappen placeres efter job titlen

### Extension virker ikke efter opdatering
- Gå til `chrome://extensions/`
- Klik "reload" på JobTracker LinkedIn extension
- Genindlæs LinkedIn siden

## Tekniske detaljer

- Manifest V3 kompatibel
- Kommunikerer via HTTP til `localhost:52525`
- Content script kører kun på `linkedin.com/jobs/*`
- Bruger MutationObserver til at håndtere LinkedIns SPA navigation
